import Utilities.waveform_creator as wc
import Utilities.mccdaq_operations as mo
import time

board_num, low_chan, high_chan = 1, 0, 0
ao_range = mo.chan_range('bipolar_10')

num, samp_freq = 500, 5000
a ,f, shape = 5., 50., 'Sine'

t = wc.create_time_data(num, samp_freq)
y = wc.create_waveform_data(t, a, f, shape)

num_points, rate = num, samp_freq

memhandle, ctypes_array = mo.create_buffer(num_points)

for i in range(num_points): 
    ctypes_array[i] = y[i]

mo.write_waveform(board_num, low_chan, high_chan,
                  num_points, rate, ao_range, memhandle)

mo.free_buffer(memhandle)

time.sleep(10.)

mo.stop_waveform(board_num)

